/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.PeacockConfig;
import com.tristankechlo.livingthings.entity.ai.PeacockDestroyCropBlocks;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PeacockEntity
extends Animal
implements ILexiconEntry {
    private static final EntityDataAccessor<Boolean> PANIC = SynchedEntityData.m_135353_(PeacockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLUFFED = SynchedEntityData.m_135353_(PeacockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DESTROYING_CROPS = SynchedEntityData.m_135353_(PeacockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UniformInt FLUFFED_TIME = TimeUtil.m_145020_((int)10, (int)60);
    private int fluffedTime;

    public PeacockEntity(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, PeacockConfig.health()).m_22268_(Attributes.f_22279_, PeacockConfig.movementSpeed());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PeacockPanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredients.PEACOCK_FOOD, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new PeacockDestroyCropBlocks(this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PANIC, (Object)false);
        this.f_19804_.m_135372_(FLUFFED, (Object)false);
        this.f_19804_.m_135372_(DESTROYING_CROPS, (Object)false);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(FLUFFED, (Object)nbt.m_128471_("Fluffed"));
        this.fluffedTime = nbt.m_128451_("FluffedTime");
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("Fluffed", ((Boolean)this.f_19804_.m_135370_(FLUFFED)).booleanValue());
        nbt.m_128405_("FluffedTime", this.fluffedTime);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(LivingThingsTags.PEACOCK_FOOD);
    }

    public static <T extends Animal> boolean checkPeacockSpawnRules(EntityType<T> entityType, ServerLevelAccessor world, MobSpawnType mobSpawnType, BlockPos pos, RandomSource randomSource) {
        return world.m_8055_(pos.m_7495_()).m_204336_(LivingThingsTags.PEACOCK_SPAWNABLE_ON) && PeacockEntity.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob parent) {
        return (AgeableMob)ModEntityTypes.PEACOCK.get().m_20615_((Level)level);
    }

    public int m_5792_() {
        return PeacockConfig.maxSpawnedInChunk();
    }

    public void setInPanic(boolean panic) {
        this.f_19804_.m_135381_(PANIC, (Object)panic);
    }

    public boolean isInPanic() {
        return (Boolean)this.f_19804_.m_135370_(PANIC) != false || this.m_21188_() != null || this.m_203117_() || this.m_6060_();
    }

    public boolean isTailFluffed() {
        return this.isInPanic() || (Boolean)this.f_19804_.m_135370_(FLUFFED) != false;
    }

    public void startFluffing() {
        this.fluffedTime = FLUFFED_TIME.m_214085_(this.f_19796_);
        this.f_19804_.m_135381_(FLUFFED, (Object)true);
    }

    public void m_27595_(Player player) {
        super.m_27595_(player);
        this.f_19804_.m_135381_(FLUFFED, (Object)true);
    }

    public void m_27594_() {
        super.m_27594_();
        this.startFluffing();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isDestroyingCrops() && this.f_19796_.m_188503_(5) == 0) {
            BlockPos pos = this.m_20183_();
            this.m_9236_().m_46796_(2001, pos, Block.m_49956_((BlockState)Blocks.f_50093_.m_49966_()));
        }
        if (this.fluffedTime > 0) {
            --this.fluffedTime;
            if (this.fluffedTime == 0) {
                this.f_19804_.m_135381_(FLUFFED, (Object)false);
                return;
            }
        }
        if (!((Boolean)this.f_19804_.m_135370_(FLUFFED)).booleanValue() && this.f_19796_.m_188503_(4000) == 0) {
            this.startFluffing();
        }
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.PEACOCK;
    }

    public int m_8100_() {
        return (Integer)PeacockConfig.get().talkInterval.get();
    }

    protected SoundEvent m_7515_() {
        return ModSounds.PEACOCK_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return ModSounds.PEACOCK_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return ModSounds.PEACOCK_DEATH.get();
    }

    public boolean isDestroyingCrops() {
        return (Boolean)this.f_19804_.m_135370_(DESTROYING_CROPS);
    }

    public void setDestroyingCrops(boolean eating) {
        this.f_19804_.m_135381_(DESTROYING_CROPS, (Object)eating);
    }

    private static class PeacockPanicGoal
    extends PanicGoal {
        public PeacockPanicGoal(PathfinderMob mob, double speed) {
            super(mob, speed);
        }

        public void m_8056_() {
            super.m_8056_();
            ((PeacockEntity)this.f_25684_).setInPanic(true);
        }

        public void m_8041_() {
            super.m_8041_();
            ((PeacockEntity)this.f_25684_).setInPanic(false);
        }
    }
}

